function [HistoRGB] = makePictureHistogram(imageData)

% Function to make histograms for pictures

[hValRed,~] = histcounts(imageData(:,:,1),256);
[hValGreen,~] = histcounts(imageData(:,:,2),256);
[hValBlue,~] = histcounts(imageData(:,:,3),256);

HistoRGB = [hValRed;hValGreen;hValBlue];

X = [1:256];

a = area(X,hValRed);
a.EdgeColor = 'red';
a.FaceColor = 'red';
a.FaceAlpha = 0.5;
hold on
a = area(X,hValGreen);
a.EdgeColor = 'green';
a.FaceColor = 'green';
a.FaceAlpha = 0.5;
a = area(X,hValBlue);
a.EdgeColor = 'blue';
a.FaceColor = 'blue';
a.FaceAlpha = 0.5;

xlabel('Counts')
ylabel('Intensity')

axis([1,256,0,4e4])

end